#include "heli.h"
#include <debris.h>
#include <tgaloader.h>

Heli::Heli(Object *parent, Roster *target) : Explosive(parent, new Texture("particle.tga")) {
	
	Texture *t1 = new Texture(), *t2 = new Texture();				//done the long way because don't need to be made actual graphics textures
	LoadTGA(t1, "debris.tga");
	LoadTGA(t2, "debrism.tga");
	Debris *debris = new Debris(parent, this, t1, t2);
	this->parent = debris;

	this->target = target;

	up = new AtomDir();
	engine = new DActuator(this, up);
	tail = new DActuator(this, up);
	aim = new RosterDir(target, NULL);
	engine->assignAtomGroup(3);
	tail->assignAtomGroup(4);

	for(int i = 0; i < MAXLEVELS; i++) {
		bulletlevels[i] = true;
	}
	bulletlevels[0] = false;
	bulletlevels[8] = false;
	bulletlevels[7] = false;

	gun = new BulletGun(this, &fire, aim, 15.0f, 0.0f, 5, 50, 1.0f, 7, bulletlevels);

	oix = 0;
	oiy = 0;
	temp = 0;
	fire = false;
	burst = 0;
}

void Heli::stepFunc() {
	Explosive::stepFunc();
	temp--;
	if(removed_links > 20) {
		fire = false;
		return;
	}

	if(target) {
		target->calculateCenter();
		x = target->cx;
	}

	float dx, dy, dist;
	Atom *c = up->back;
	dx = x - c->x;
	dy = y - c->y;
	dist = dx * dx + dy * dy;

	burst--;
	if(dist > 360000)
		fire = false;
	else
		fire = (burst > 0);
	if(burst < -100) burst = 50;

	float appforce, maxapp;

	//PERFECT PILOT
	//appforce = dy * 0.02f - up->iy * 2.3f;// + 0.623f;
	//appforce += 0.623f;
	//appforce += (rand() % 20) * 0.02f - 0.1f;
	//maxapp = 0.1f;

	//CRAZY PILOT
	appforce = dy * 0.0025f - up->iy * 0.002f;// + 0.623f;
	//appforce = 0.623f;
	//appforce = 0.0f;
	maxapp = 2.0f;

	//appforce = 0.623f;
	if(appforce > maxapp) appforce = maxapp;
	if(appforce < -maxapp) appforce = -maxapp;
	float ax = up->ix - oix;
	oix = up->ix;
	
	//if(dy > 0)
	engine->applyForce(appforce);

	float dty = up->front->y - (tail_atom->y - 1);
	if(dty > 20.0f) dty = 10.0f + (dty - 10.0f) * 3.0f;
	if(dty < -10.0f) dty = -10.0f + (dty + 10.0f) * 3.0f;
	/*
	if(dx > 90.0f) dx = 90.0f;
	if(dx < -90.0f) dx = -90.0f;
	if(dx > 60.0f) dx -= 60.0f;
	else if(dx < -60.0f) dx += 60.0f;
	else {
		dx *= 0.1f;
		//dx *= 0.5f;
		if(fabs(up->ix) < 2.0f || 1) {
			//dx *= 0.0f;
			up->ix *= 2.0f;
			ax *= 1.0f;
			//dty *= 2.0f;
		}
	}
	*/
	if(dx > 60.0f) dx = 60.0f;
	if(dx < -60.0f) dx = - 60.0f;
	//dx = 0.0f;
	float ty = tail_atom->y - tail_atom->oy;
	float rel;
	//rel = 0.232f;

	//PERFECT PILOT
	//rel = 0.172f + dty * 0.005f + -ty * 1.0f + 0.2f * up->ix + 10.0f * ax - 0.01f * dx;

	//CRAZY PILOT
	//rel = dty * 0.01f + -ty * 0.1f + 0.25f + 0.08f * up->ix + 4.0f * ax - 0.001f * dx;
	rel = dty * 0.01f + -ty * 0.1f + 0.25f + 0.08f * up->ix + 10.0f * ax - 0.001f * dx;

	/*
	if(fabs(ty) > 1.0f) {
		float dif = fabs(ty) - 0.0f;
		rel /= dif;
	}
	*/
	//rel /= ty * 0.1f;
	
	
	appforce = rel;
	maxapp = 0.6f;
	if(appforce > maxapp) appforce = maxapp;
	if(appforce < -maxapp) appforce = -maxapp;
	tail->applyForce(appforce);	
}

void Heli::addAtom(Atom *a) {
	Explosive::addAtom(a);

	if(a->group == 1)
		up->front = a;
	if(a->group == 2)
		up->back = a;
	if(a->group == 5)
		tail_atom = a;
	if(a->group == 6)
		aim->atom = a;
}

void Heli::addLink(Link *l) {
	Explosive::addLink(l);

	//l->draw = true;
}

void Heli::addPoly(Poly *p) {
	Explosive::addPoly(p);

	//p->l1->draw = true;
	//p->l2->draw = true;
	//p->l3->draw = true;
}